<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Status extends Model 
{

    protected $table = 'status';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function comments()
    {
        return $this->hasMany('App\Models\Comment', 'status_id');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

}